############### ###############
## F_H4_A_abs_deviation_relative_perf
## Project: CBO
## Author: Kamil Kouhen
## Date of creation: 23/06/2022
############### ###############

#Uniform Path
path <- here("Output/For Publication/Figures/F_")

  ggplot(DM_final %>% drop_na(A_abs_deviation_relative_perf),
         aes(x = A_abs_deviation_relative_perf)) + 
    geom_histogram(binwidth = 1) + 
    labs(
      x = "Sum of absolute deviations between the perceived and actual municipal performance quintiles, \n across all groups of indicators, in 2018", 
      y = "Number of decision makers"
    ) +
    theme_minimal() +
    facet_wrap(factor((DM_final %>% drop_na(A_abs_deviation_relative_perf))$respondent_type)) +
    theme(text = element_text(size=11, family="Times")) +
    theme(plot.margin=grid::unit(c(0,0,0,0), "mm"))
  
  ggsave(width = 7, height = 3, filename = paste0(path, "H4_", "A_abs_deviation_relative_perf.png"), device = png,  dpi=200)




